**************************************************************************************************
*******************LOCAL INCOME INEQUALITY AND HOUSEHOLD INDEBTEDNESS ****************************
*************************ROBUSTNESS CHECK USING TOP 10% SHARE ************************************
*************************DATE: JAN 2022 **********************************************************
*************************AUTHOR: KIM NGUYEN ******************************************************
**************************************************************************************************

clear all
set more off
set maxvar 30000
set matsize 10000

//Load data
use "UnbalancedHH_analytical.dta", clear

//Global vars
global DemCovar "age age2 sex Luni Lkids Ladults Lmarried Lemp Lnilf Lselfemp Duni Dkids Dadults Dmarried Demp Dnilf Dselfemp"
global FinCovar "Lginc Dginc Lassets Dassets Lfinassets Dfinassets"
global MacroCovar "Lmedhp Dmedhp Lurate Durate"

//TABLE A1: Effects of a one standard deviation increase in Gini coefficient

*Total debt
eststo m1: quietly xtreg Ddebttoinc Dtop10 $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0, vce(cluster hhssa3)
*Mortgage debt
eststo m2: quietly xtreg Dmortgagedebttoinc Dtop10 $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0, vce(cluster hhssa3)
*Home debt
eststo m3: quietly xtreg Dhomedebttoinc Dtop10 $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0, vce(cluster hhssa3)
*Other property debt
eststo m4: quietly xtreg Dopropdebttoinc Dtop10 $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0, vce(cluster hhssa3)
*Non-ortgage debt
eststo m5: quietly xtreg Dnmdebttoinc Dtop10 $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0, vce(cluster hhssa3)
*Credit card debt
eststo m6: quietly xtreg Dccdebttoinc Dtop10 $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0, vce(cluster hhssa3)
*Car debt
eststo m7: quietly xtreg Dcardebttoinc Dtop10 $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0, vce(cluster hhssa3)
*Hire-purchase debt
eststo m8: quietly xtreg Dhiredebttoinc Dtop10 $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0, vce(cluster hhssa3)
*Business debt
eststo m9: quietly xtreg Dbusdebttoinc Dtop10 $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0, vce(cluster hhssa3)
*Investment debt
eststo m10: quietly xtreg Dinvdebttoinc Dtop10 $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0, vce(cluster hhssa3)

*save table
esttab m1 m2 m3 m4 m5 m6 m7 m8 m9 m10 using "Tables\Table A1 - Effects of Change in Top 10 pc share.csv",  b(2) se(2) keep(*Dtop10*) margin title(Debt regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps

//TABLE A2 
//Panel A: Effects on Investment Debt and Car Debt - by Income Quantile

*Investment debt
eststo m1: quietly xtreg Dinvdebttoinc c.Dtop10#i.Lincg #i.Lincg $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0, vce(cluster hhssa3)
*Car Debt
eststo m3: quietly xtreg Dcardebttoinc c.Dtop10#i.Lincg #i.Lincg $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0, vce(cluster hhssa3)

//Panel A: Effects on Investment Debt and Car Debt - by Financial Prosperity

*Investment debt
eststo m2: quietly xtreg Dinvdebttoinc c.Dtop10#i.Lselfrank #i.Lselfrank $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0, vce(cluster hhssa3)
*Car Debt
eststo m4: quietly xtreg Dcardebttoinc c.Dtop10#i.Lselfrank #i.Lselfrank $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0, vce(cluster hhssa3)

*save table
esttab m1 m2 m3 m4 using "Tables\Table A2 - By Income Quantile and Financial Prosperity - Top10.csv",  b(2) se(2) keep(*Dtop10*) margin title(Debt regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps


//TABLE A3
//Panel A: Effects on Investment Debt and Car Debt - by Life Cycle

*Investment debt
eststo m1: quietly xtreg Dinvdebttoinc c.Dtop10#i.Lageg #i.Lageg $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0, vce(cluster hhssa3)
*Car Debt
eststo m3: quietly xtreg Dcardebttoinc c.Dtop10#i.Lageg #i.Lageg $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0, vce(cluster hhssa3)

//Panel A: Effects on Investment Debt and Car Debt - by Housing Status

*Investment debt
eststo m2: quietly xtreg Dinvdebttoinc c.Dtop10#i.Lhsa #i.Lhsa $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0, vce(cluster hhssa3)
*Car Debt
eststo m4: quietly xtreg Dcardebttoinc c.Dtop10#i.Lhsa #i.Lhsa $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0, vce(cluster hhssa3)

*save table
esttab m1 m2 m3 m4 using "Tables\Table A3 - By Life Cycle and Housing Status - Top10.csv",  b(2) se(2) keep(*Dtop10*) margin title(Debt regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps


//TABLE A4
//Panel A: Effects on Investment Debt and Car Debt - by Htm

*Investment debt
eststo m1: quietly xtreg Dinvdebttoinc c.Dtop10#i.Lhtm #i.Lhtm $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0, vce(cluster hhssa3)
*Car Debt
eststo m4: quietly xtreg Dcardebttoinc c.Dtop10#i.Lhtm #i.Lhtm $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0, vce(cluster hhssa3)

//Panel B: Effects on Investment Debt and Car Debt - by Ability to Raise Money Easily

*Investment debt
eststo m2: quietly xtreg Dinvdebttoinc c.Dtop10#i.Leasyraise i.Leasyraise $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Car Debt
eststo m5: quietly xtreg Dcardebttoinc c.Dtop10#i.Leasyraise i.Leasyraise $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)

//Panel C: Effects on Investment Debt and Car Debt - by Financial Risk

*Investment debt
eststo m3: quietly xtreg Dinvdebttoinc c.Dtop10#i.Lfinrisk #i.Lfinrisk $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0, vce(cluster hhssa3)
*Car Debt
eststo m6: quietly xtreg Dcardebttoinc c.Dtop10#i.Lfinrisk #i.Lfinrisk $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0, vce(cluster hhssa3)

*save table
esttab m1 m2 m3 m4 m5 m6 using "Tables\Table A4 - By HTM and Financial Attitude - Top10.csv",  b(2) se(2) keep(*Dtop10*) margin title(Debt regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps


